package command;

import util.Response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class EchoCommand implements CommandHandler {
    private final List<String> args;
    public EchoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public void execute(OutputStream os) {
        try {
            os.write(Response.getResponse(args.getFirst()));
            os.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
