import server.Server;
import server.ServerBuilder;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        logger.info("Starting application");
        try {
            ServerBuilder builder = new ServerBuilder(args);
            try (Server server = builder.build()) {
                server.start();
            }
        } catch (Exception e) {
            logger.log(Level.SEVERE, "An error occurred", e);
        }
        logger.info("Application shutdown complete");
    }
}