package server;


import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceInfo {
    private static ServiceInfo serviceInfo;
    private final Map<String, String> info = new ConcurrentHashMap<>();

    private ServiceInfo() {
        info.put("role", "master");
        info.put("cachePolicyName", "caffeine");
    }

    public static ServiceInfo getInstance() {
        if (serviceInfo == null) {
            serviceInfo = new ServiceInfo();
        }
        return serviceInfo;
    }

    public String getRole() {
        return serviceInfo.info.get("role");
    }

    public String[] findRole(Map<String, String> parameters) {
        String[] masterPortAndHost = new String[]{};
        String role = "master";
        if (parameters.containsKey("--replicaof")) {
            masterPortAndHost = parameters.get("--replicaof").split(" ");
            role = "slave";

        } else {
            info.put("master_repl_offset", "0");
            info.put("master_replid", "8371b4fb1155b71f4a04d3e1bc3e18c4a990aeeb");
        }
        info.put("role", role);
        return masterPortAndHost;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }
}
