package command.validation;

import java.util.List;

public final class EchoCommandValidator implements Validatable {
    private static final EchoCommandValidator INSTANCE = new EchoCommandValidator();

    private EchoCommandValidator() {
    }

    public static EchoCommandValidator getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isValid(List<String> args) {
        return !args.isEmpty() && args.getFirst() != null;
    }
}
