package command;


import org.junit.Test;
import util.Response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static org.junit.Assert.assertArrayEquals;

public class EchoCommandTest {
    @Test
    public void test_execute_with_non_empty_args() {
        List<String> args = List.of("hello");
        EchoCommand command = new EchoCommand(args);
        byte[] result = command.execute();
        byte[] expected = Response.getResponse("hello");
        assertArrayEquals(expected, result);
    }

    @Test
    public void test_execute_with_null_args() {
        List<String> args = Collections.singletonList((String) null);
        EchoCommand command = new EchoCommand(args);
        byte[] result = command.execute();
        byte[] expected = "".getBytes();
        assertArrayEquals(expected, result);
    }
    @Test
    public void test_execute_with_long_strings() {
        List<String> longArgs = new ArrayList<>();
        StringBuilder longString = new StringBuilder();
        for (int i = 0; i < 10000; i++) {
            longString.append("a");
        }
        longArgs.add(longString.toString());
        EchoCommand command = new EchoCommand(longArgs);
        byte[] result = command.execute();
        byte[] expected = Response.getResponse(longString.toString());
        assertArrayEquals(expected, result);
    }
}