package command;


import model.Command;
import server.SendToReplica;
import server.ServiceInfo;
import util.RdbFileInfo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FullRsyncCommand implements CommandExecutable<byte[]> {
    private final SendToReplica replicaSender;
    private final RdbFileInfo rdbFileInfo;
    private final OutputStream outputStream;
    private final ServiceInfo serviceInfo;

    public FullRsyncCommand(SendToReplica replicaSender, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.replicaSender = replicaSender;
        rdbFileInfo = RdbFileInfo.getInstance();
        this.serviceInfo = ServiceInfo.getInstance();
    }

    @Override
    public byte[] execute() {
        synchronized (this) {
            replicaSender.addConnection(outputStream);
            byte[] decode = rdbFileInfo.getContent();
            try {
                return createCommandBytes(Command.FULLRESYNC, decode, serviceInfo);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

    }

    public byte[] createCommandBytes(Command command, byte[] decode, ServiceInfo serviceInfo) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(("+" + command.getValue() + " " + serviceInfo.getInfo().get("master_replid") + " 0\r\n").getBytes());
        byteArrayOutputStream.write(("$" + decode.length + "\r\n").getBytes());
        byteArrayOutputStream.write(decode);
        return byteArrayOutputStream.toByteArray();
    }

}
