package command;

import command.validation.Validatable;

import java.io.IOException;
import java.util.List;

public interface CommandExecutable<T> {
    T execute() throws IOException;

    class GetCommandValidator implements Validatable {
        private static final GetCommandValidator INSTANCE = new GetCommandValidator();

        private GetCommandValidator() {
        }

        public static GetCommandValidator getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isValid(List<String> args) {
            return args != null && args.size() == 1;
        }
    }
}
