package command;


import org.junit.Test;

import static org.junit.Assert.assertArrayEquals;

public class UnknownCommandTest {

    @Test
    public void test_execute_with_message() {
        String testMessage = "Test Message";
        UnknownCommand command = new UnknownCommand(testMessage);
        byte[] result = command.execute();
        assertArrayEquals(testMessage.getBytes(), result);
    }

    @Test
    public void test_execute_with_null_message() {
        UnknownCommand command = new UnknownCommand();
        byte[] result = command.execute();
        assertArrayEquals("-Unknown Command\r\n".getBytes(), result);
    }
}