package command;

import model.Command;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CommandValidator {

    private CommandValidator() {
    }

    private static final class InstanceHolder {
        private static final CommandValidator instance = new CommandValidator();
    }

    public static CommandValidator getInstance() {
        return InstanceHolder.instance;
    }

    public boolean validateSetCommand(List<String> args) {
        if (args == null || args.isEmpty()) {
            return false;
        }

        if (args.size() < 2) {
            return false;
        }

        if (args.size() > 2) {
            Map<String, String> commandsMap = IntStream.iterate(2, i -> i < args.size(), i -> i + 2)
                    .boxed()
                    .collect(Collectors.toMap(i -> args.get(i).toLowerCase(), i -> args.get(i + 1), (a, b) -> b));

            String expiration = commandsMap.get(Command.PX.getValue().toLowerCase());
            if (expiration != null) {
                try {
                    Long.parseLong(expiration);
                } catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        return true;
    }

    public boolean validateGetCommand(List<String> args) {
        return args != null && args.size() == 1;
    }


    public boolean validateInfoCommand(List<String> args) {
        return args != null && args.size() == 1 && "replication".equalsIgnoreCase(args.getFirst());
    }
}
