package command.replica;

import command.CommandExecutable;
import storage.Storage;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReplicaSetCommand implements CommandExecutable<Void> {
    private final Storage storage = Storage.getInstance();
    private final List<String> args;
    private static final Logger logger = Logger.getLogger(ReplicaSetCommand.class.getName());

    public ReplicaSetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public Void execute() {
        String key = args.get(0).toLowerCase();
        String value = args.get(1);

        String expiration = null;
        for (int i = 2; i < args.size() - 1; i += 2) {
            if ("px".equalsIgnoreCase(args.get(i))) {
                expiration = args.get(i + 1);
                break;
            }
        }

        if (expiration != null) {
            try {
                long expirationTime = Long.parseLong(expiration);
                storage.save(key, value, expirationTime);
            } catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "NumberFormatException", e);
            }
        } else {
            storage.save(key, value);
        }
        return null;
    }
}