package command;


import model.Command;
import server.SendToReplica;
import server.ServerInfo;
import util.RdbFileInfo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FullRsyncCommand implements CommandExecutable<byte[]> {
    private final SendToReplica replicaSender;
    private final RdbFileInfo rdbFileInfo;
    private final OutputStream outputStream;
    private final ServerInfo serverInfo;

    public FullRsyncCommand(SendToReplica replicaSender, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.replicaSender = replicaSender;
        rdbFileInfo = RdbFileInfo.getInstance();
        this.serverInfo = ServerInfo.getInstance();
    }

    @Override
    public byte[] execute() {
        synchronized (this) {
            replicaSender.addConnection(outputStream);
            byte[] decode = rdbFileInfo.getContent();
            try {
                return createCommandBytes(Command.FULLRESYNC, decode, serverInfo);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

    }

    public byte[] createCommandBytes(Command command, byte[] decode, ServerInfo serverInfo) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(("+" + command.getValue() + " " + serverInfo.getInfo().get("master_replid") + " 0\r\n").getBytes());
        byteArrayOutputStream.write(("$" + decode.length + "\r\n").getBytes());
        byteArrayOutputStream.write(decode);
        return byteArrayOutputStream.toByteArray();
    }

}
