package storage;



import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CaffeineCachePolicy<K, V> implements CachePolicy<K, V> {
    private final Cache<K, V> cache;
    private static final Logger logger = Logger.getLogger(CaffeineCachePolicy.class.getName());

    public CaffeineCachePolicy(int maxCapacity) {
        this.cache = Caffeine.newBuilder()
                .maximumSize(maxCapacity)
                .expireAfterAccess(60, TimeUnit.MINUTES)
                .evictionListener((K key, V value, RemovalCause cause) ->
                        logger.info("Evicted key: " + key + ", Value: " + value + ", Reason: " + cause))
                .build();
    }

    @Override
    public void add(K key, V value) {
        cache.put(key, value);
    }

    @Override
    public V retrieve(K key) {
        return cache.getIfPresent(key);
    }

    @Override
    public void delete(K key) {
        cache.invalidate(key);
    }

    @Override
    public void runMaintenance() {
        cache.cleanUp();
    }
}
