package command;


import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertThrows;

public class CommandInvokerTest {


    @Test
    public void test_command_execution_success() throws IOException {
        CommandExecutable<byte[]> command = () -> "test".getBytes();
        byte[] result = CommandInvoker.invoke(command);
        assertArrayEquals("test".getBytes(), result);
    }

    @Test
    public void test_command_execution_throws_ioexception() {
        CommandExecutable<byte[]> command = () -> {
            throw new IOException("Test exception");
        };
        assertThrows(IOException.class, () -> CommandInvoker.invoke(command));
    }
}