package command;


import org.junit.Test;

import java.util.List;
import java.util.NoSuchElementException;

import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThrows;

public class ReplConfCommandTest {


    @Test
    public void test_execute_returns_null_for_ack() {
        List<String> args = List.of("ACK");
        ReplConfCommand command = new ReplConfCommand(args);
        byte[] result = command.execute();
        assertNull(result);
    }

    @Test
    public void test_execute_with_empty_args_list() {
        List<String> args = List.of();
        ReplConfCommand command = new ReplConfCommand(args);
        assertThrows(NoSuchElementException.class, command::execute);
    }
}