package command;

import org.junit.Assert;
import org.junit.Test;
import server.SendToReplica;
import server.ServiceInfo;
import util.RdbFileInfo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class FullRsyncCommandTest {

    @Test
    public void test_rdb_file_content_empty() throws Exception {
        SendToReplica mockReplicaSender = mock(SendToReplica.class);
        RdbFileInfo mockRdbFileInfo = mock(RdbFileInfo.class);
        ServiceInfo mockServiceInfo = mock(ServiceInfo.class);
        OutputStream mockOutputStream = new ByteArrayOutputStream();

        byte[] expectedContent = new byte[0];
        when(mockRdbFileInfo.getContent()).thenReturn(expectedContent);
        when(mockServiceInfo.getInfo()).thenReturn(Map.of("master_replid", "8371b4fb1155b71f4a04d3e1bc3e18c4a990aeeb"));

        FullRsyncCommand command = new FullRsyncCommand(mockReplicaSender, mockOutputStream);
        byte[] result = command.execute();

        ByteArrayOutputStream expectedOutput = new ByteArrayOutputStream();
        expectedOutput.write(("+FULLRESYNC 8371b4fb1155b71f4a04d3e1bc3e18c4a990aeeb 0\r\n").getBytes());
        expectedOutput.write(("$" + expectedContent.length + "\r\n").getBytes());
        expectedOutput.write(expectedContent);

        assertArrayEquals(expectedOutput.toByteArray(), result);
    }

    @Test
    public void test_execute_fullresync_command() throws Exception {
        SendToReplica mockReplicaSender = mock(SendToReplica.class);
        RdbFileInfo mockRdbFileInfo = mock(RdbFileInfo.class);
        ServiceInfo mockServiceInfo = mock(ServiceInfo.class);
        OutputStream mockOutputStream = new ByteArrayOutputStream();

        byte[] expectedContent = "testContent".getBytes();
        when(mockRdbFileInfo.getContent()).thenReturn(expectedContent);
        when(mockServiceInfo.getInfo()).thenReturn(Map.of("master_replid", "8371b4fb1155b71f4a04d3e1bc3e18c4a990aeeb"));

        FullRsyncCommand command = new FullRsyncCommand(mockReplicaSender, mockOutputStream);
        byte[] result = command.execute();

        ByteArrayOutputStream expectedOutput = new ByteArrayOutputStream();
        expectedOutput.write(("+FULLRESYNC 8371b4fb1155b71f4a04d3e1bc3e18c4a990aeeb 0\r\n").getBytes());
        expectedOutput.write(("$" + expectedContent.length + "\r\n").getBytes());
        expectedOutput.write(expectedContent);

        Assert.assertArrayEquals(expectedOutput.toByteArray(), result);
    }
}
