package factory;

import command.*;
import model.Command;
import server.SendToReplica;

import java.io.OutputStream;
import java.util.List;

public final class CommandFactory implements ExecutablesFactory {

    private static final class FactoryHolder {
        private static final CommandFactory factory = new CommandFactory();
    }

    public CommandFactory() {
    }

    public static CommandFactory getInstance() {
        return FactoryHolder.factory;
    }

    @Override
    public CommandExecutable<byte[]> getCommand(Command command, List<String> args) {
        return switch (command) {
            case PING -> new PingCommand();
            case ECHO -> new EchoCommand(args);
            case SET -> new SetCommand(args);
            case GET -> new GetCommand(args);
            case INFO -> new InfoCommand(args);
            case REPLCONF -> new ReplConfCommand(args);
            default -> new UnknownCommand();
        };
    }

    public CommandExecutable<byte[]> getCommand(Command command, List<String> args, SendToReplica sender, OutputStream os) {
        return switch (command) {
            case PING -> new PingCommand();
            case ECHO -> new EchoCommand(args);
            case SET -> new SetCommand(args);
            case GET -> new GetCommand(args);
            case INFO -> new InfoCommand(args);
            case REPLCONF -> new ReplConfCommand(args);
            case PSYNC -> new FullRsyncCommand(sender, os);
            default -> new UnknownCommand();
        };
    }
}
