package command.validation;

import java.util.List;

public final class InfoCommandValidator implements Validatable {
    private static final InfoCommandValidator INSTANCE = new InfoCommandValidator();

    private InfoCommandValidator() {
    }

    public static InfoCommandValidator getInstance() {
        return INSTANCE;
    }
    @Override
    public boolean isValid(List<String> args) {
        return args != null && args.size() == 1 &&
                "replication".equalsIgnoreCase(args.getFirst());
    }
}
