
---

# **Project Name**

## **Overview**

This project is a **Key_Value Server implementation in java** that implements a **Replication**. It is designed to handle multiple clients, efficiently manage caching, and execute commands in a reliable and scalable manner.

## **Project Structure**

The project is organized into several directories, each responsible for different components of the system:

- **`/commands`**: Contains the implementation of command handling. This directory includes classes and methods that define how commands are processed, executed, and managed within the system.

- **`/clients`**: Manages client interactions with the system. This directory includes:
    - **`master client `**: Handles the communication and request processing for the master client.
    - **`replica client `**: Manage how replica client see or handle the incoming Commands from the master.
- **`/parser`**: how we parse the command (Resp).
- **`/handlers`**: how each type of clients handle its own business
- **`/server`**: Contains the core server components. This directory includes the main server logic, networking, and the orchestration of client requests and command executions.

- **`/storage`**: Focuses on the storage and caching mechanisms. This directory includes:
    - **Storage system components**: Manages the Caching system.
    - **Caching system components**: Implements caching strategies to improve performance and reduce latency.

## **Attention**
You have no thing to do with any thing that specific to **Rdb** it just like configuration that needed for synchronization with replica (like Redis). 
## **Getting Started**

### **Prerequisites**

Before you start, make sure you have the following installed on your machine:

- **Java JDK** (version 21 or higher)
- **redis-cli** (for easier testing)

### **Installation**

1. **Clone the repository:**

   ```bash
   git clone https://git.hiast.edu.sy/amir.yosef/key_value-server
   cd key_value-server
   ```

2. **Build the project:**

   Use intellij Idea for building .

### **Running the Server**

To start the server:

1. **in the project directory ( class main args) :**

   ```Run configuration (args)
   you can customize the type of the server,
   if you passed the --Port <number> parameter the server will be starts on this port.
   if you passsed the --replicaof "<master host> <master port" the type will be Replica Server. 
   ```

2. **Run the server:**

   ```Directly
    using intellij Idea
   ```

   The server will start and listen for client connections.

### **Using Jar file**

after indexing required libraries.

1. **in Intellij add an artifact of the project using project structure in settings tab:**


2. **Build the Jar**

in intellij click on Build tap and build artifacts.

3.  **Run the jar**

 - navigate to the output (out) directory using terminal and do this:
 - if you want to create Master Server just pass:
```bash
   java -jar out/Server.jar --Port <number>
   ```
 - if you want to create Replica Server ( Master Server required):
```bash
   java -jar out/Server.jar --Port <number> --replicaof "<master host> <master port>"
   ```
### **Command Execution**

Commands are processed through the `/commands` module, which handles various types of commands (e.g., Set, Get, etc.). To execute a command:

1. **Use the redis-cli to send a command:**
    use redis-cli on linux and pass it the host and port number (-h host -p port).
   Commands are typically sent from the master client to the server. The server processes the command and responds accordingly.

   
### **Storage and Caching**

The project uses a combination of managing storage and caching strategies to optimize performance:

- **Storage:** Manages the Storage components.
- **Caching:** Implements caching to store frequently accessed data in memory, reducing the need to query the storage system repeatedly.
