package command;


import model.Command;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PingCommand implements CommandHandler {

    @Override
    public void execute(List<String> args, OutputStream os) {
        System.out.printf("Processing PING args %s%n", args);
        try {
            os.write(("+" + Command.PONG.getValue() + "\r\n").getBytes());
            os.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}