package storage;


import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Storage {
    private final Map<String, String> storage = new ConcurrentHashMap<>(10000);
    private final Map<String, Long> timeToExpiration = new ConcurrentHashMap<>(10000);
    private final Map<String, Long> currentTimeForKey = new ConcurrentHashMap<>(10000);


    private Storage() {
        //    RdbFileReader reader = new RdbFileReader();
        //Map<String, String> stringStringMap = reader.readFile();
        //  storage.putAll(stringStringMap);
        //Map<String, Long> keysExpiration = reader.getKeysExpiration();
        //  timeToExpiration.putAll(keysExpiration);
    }

    private static final class StorageHolder {
        private static final Storage storage = new Storage();
    }


    public static Storage getInstance() {
        return StorageHolder.storage;
    }

    public void save(String key, String value) {
        storage.put(key, value);
    }

    public void save(String key, String value, Long time) {
        System.out.println("SAVE Storage: " + key);
        currentTimeForKey.put(key, System.currentTimeMillis());
        timeToExpiration.put(key, time);
        save(key, value);
    }

    public String get(String key) {
        if (isExpired(key)) return "";
        return storage.get(key);
    }

    private boolean isExpired(String key) {
        if (timeToExpiration.containsKey(key) && !currentTimeForKey.containsKey(key)) {
            long currentTime = System.currentTimeMillis();
            long expirationTime = timeToExpiration.get(key);
            if (currentTime > expirationTime) {
                System.out.println("Key expired: " + key);
                return true;
            }
        }
        if (currentTimeForKey.containsKey(key)) {
            long currTime = System.currentTimeMillis();
            long expirationTime = timeToExpiration.get(key);
            long currExpiration = currentTimeForKey.get(key);
            return currTime - currExpiration > expirationTime;
        }
        return false;
    }


}
