package factory;

import command.*;
import model.Command;

public class CommandFactory implements Factory {
    private final Command command;

    public CommandFactory(Command command) {
        this.command = command;
    }

    public CommandHandler getInstance() {
        return switch (command) {
            case PING -> new PingCommand();
            case ECHO -> new EchoCommand();
            case SET -> new SetCommand();
            case GET -> new GetCommand();
            case INFO -> new InfoCommand();
//            case REPLCONF -> new ReplConfCommand(replicaReceiver);
//            case PSYNC -> new FullResyncCommandProcessor(replicaSender);
//            case WAIT -> new WaitCommandProcessor(replicaSender, replicaReceiver);
//            case CONFIG -> new ConfigCommandProcessor();
//            case KEYS -> new KeysCommandProcessor();
//            case TYPE -> new TypeCommandProcessor();
//            case XADD -> new XaddCommandProcessor();
//            case XRANGE -> new XrangeCommandProcessor();
//            case XREAD -> new XreadCommandProcessor();
//            case INCR -> new IncrCommandProcessor();
//            case MULTI -> new MultiCommandProcessor(transactionMultiCommandService);
//            case EXEC -> new ExecCommandProcessor(transactionMultiCommandService);
//            case DISCARD -> new DiscardCommandProcessor(transactionMultiCommandService);
            default -> new UnknownCommand();
        };
    }

}
