package command;

import model.Command;
import storage.Storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetCommand implements CommandHandler {
    private final Storage redisStorage = Storage.getInstance();

    @Override
    public void execute(List<String> args, OutputStream os) {

        Map<String, String> commandsMap = new HashMap<>();

        for (int i = 2; i < args.size(); i += 2) {
            commandsMap.put(args.get(i).toLowerCase(), args.get(i + 1));
        }

        String value = args.get(1);

        String expiration = commandsMap.get(Command.PX.getValue().toLowerCase());
        if (expiration != null) {
            try {
                Long expirationTime = Long.parseLong(expiration);
                redisStorage.save(args.getFirst().toLowerCase(), value, expirationTime);
            } catch (NumberFormatException e) {
                System.out.println("NumberFormatException:  " + e.getMessage());
            }
        } else {
            redisStorage.save(args.getFirst().toLowerCase(), value);
        }

        try {
            os.write("+OK\r\n".getBytes());
            os.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
