package server;

import util.Settings;

import java.util.Map;

public class ServerBuilder {
    private int port = 6379;
    private String role;
    String[] masterPortAndHost;
    private final static ServerInfo info = ServerInfo.getInstance();
    Map<String, String> parameters;

    public void setPort(int port) {
        this.port = Settings.extractPort(parameters, port);
    }

    public ServerBuilder(String[] args) {
        this.parameters = Settings.extractArgs(args);
        this.port = Settings.extractPort(parameters, port);
        this.masterPortAndHost = info.findRole(parameters);
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Server build() {
        return new Server(port, role);
    }
}
