import * as d3 from 'd3';
import { ChartConfiguration } from "../chart-base/chart-configuration";
import { PolarAreaChart } from '../charts/polar-area-chart';

export class PloarAreaChartHelper {
    private container: any;
    private containerId: string = 'polar-area-chart-container';
    private svgId: string = 'polar-area-chart';

    private selector: any;

    private config: ChartConfiguration = new ChartConfiguration(`#${this.svgId}`, { width: 500, height: 408 });
    private chart: PolarAreaChart;

    private data: any[] = [];

    public setData(data: any) {
        this.data = data;
    }

    public appendChart() {
        // Add div container
        this.container = d3.select('#medalDistributionBySportChart')
            .append('div')
            .attr('class', 'container')
            .attr('style', 'width: fit-content;')
            .attr('id', `${this.containerId}`);

        // Add year selector
        this.selector = this.container.append('div')
            .attr('id', 'polar-area-chart-selector')
            .attr('class', 'text-center mt-4');

        this.selector.append('label')
            .attr('for', 'yearSelector')
            .attr('class', 'form-label')
            .style('font-weight', 'bold')
            .text('Select year:');
        this.selector.append('select')
            .attr('class', 'form-select text-center')
            .append('option').attr('value', 'all').text('All years');
        const selectField = this.selector.select('select');
        const years = Array.from(new Set(this.data.map(d => d.Year))); // Get unique years
        years.forEach(year => {
            selectField.append("option")
                .attr("value", year)
                .text(year);
        });
        // add select event handler
        const visHelper = this;
        selectField.on("change", function (event: any) {
            const selectedYear = d3.select(event.target).property("value");
            visHelper.updateChart(selectedYear);
        });

        // add svg for chart
        this.container
            .append('svg')
            .attr('id', `${this.svgId}`);

        // init chart
        this.chart = new PolarAreaChart(this.config);
        this.updateChart("all");

    }

    private updateChart(selectedYear: string) {
        // this.chart.data = this.processData(selectedYear);
        this.chart.data = this.processData(selectedYear);
        this.chart.updateVis();
    }

    private processData(selectedYear: string) {
        const filteredData = selectedYear !== 'all' ? this.data.filter(d => d.Year === selectedYear) : this.data;

        const sportCountMap: { [key: string]: number } = {};
        filteredData.forEach(d => {
            const sport = d.Sport;
            if (sportCountMap[sport]) {
                sportCountMap[sport]++;
            } else {
                sportCountMap[sport] = 1;
            }
        });

        const result: any[] = Object.keys(sportCountMap).map(key => ({
            key: key,
            value: sportCountMap[key]
        }));
        return result.sort((a, b) => b.value - a.value).slice(0, 10);
    }
}

