# Olympic Games Dashboard

## Project Details
- Data Visualization (DV) Course - Final Mini Project
    - Data Visualization using D3.js
- By: Almouhannad Hafez

## Table of Contents
- [Introduction](#introduction)
- [Features](#features)
- [Visualizations](#visualizations)
- [How to Run](#how-to-run)
- [Technologies Used](#technologies-used)
- [Folders Architecture](#folders-architecture)
- [Contributing](#contributing)

## Introduction
This project is a comprehensive dashboard that visualizes data from the Olympic Games using D3.js. It aims to provide insights into various aspects of the games, including medal counts, athlete performances, and historical trends.

## Features
- Interactive visualizations of Olympic data
- Filter options for different countries and events
- Easy navigation and user-friendly interface
- Reusable, clean, and self-documented code following design principles

## Visualizations

> ***More screenshots are available in `screenshots` folder***

1. **Stacked Bar Chart**
    - Shows the distribution of medals won by each country in order
    - Can navigate through rankings of countries (Sorted based on total medals won)
    - Can filter by medal type (Bronze, Silver, and Gold)

    ![BarChart1](/screenshots/BarChart/1.png)

1. **Multi Line Chart**
    - Shows the trends of medals won by countries over time
    - Can navigate through rankings of countries (Sorted based on total medals won)
    - Can focus on a specific country to see its line clearly

    ![LineChart1](/screenshots/LineChart/1.png)   

1. **Pie Chart**
    - Shows the distribution of medals won over genders
    - Can select year to show its distribution

    ![PieChart1](/screenshots/PieChart/1.png)    
    
1. **Polar Area Chart**
    - Shows the distribution of medals won over different sports in olympic games
    - Can select year to show its distribution
    - Can focus on some arc of the chart to see its information clearly

    ![AreaChart1](/screenshots/PolarChart/1.png)           

## How to Run
To run this project locally, follow these steps:

1. **Clone the repository**
    ```bash
    git clone https://git.hiast.edu.sy/almohanad.hafez/dv-project.git Olympic-games-dashboard
    cd Olympic-games-dashboard
    ```    

2. **Install dependencies**    
    ```bash
    npm install
    ```

3. **Run the local server**
    ```bash
    npm run dev
    ```

4. **Open your browser** and navigate to `http://localhost:3000` to view the dashboard.

## Technologies Used
- **D3.js** for data visualization.
- **Node.js** for the server.
- **Vite** as the build tool and development server, offering fast hot module replacement and optimized builds for a smoother development experience.
- **HTML/CSS** for the frontend.
- **Bootstrap** for quick and easy styling of components.
- **npm** for package management.

## Folders Architecture
1. `data` folder: Contains dataset
1. `public` folder: Contains public assets (icon, and logo)
1. `screenshot` folder: Contains some screenshots from visualizations
1. `.env` file: Environment variables (dataset path)
1. `index.html` file: Main page for the project
1. `package.json`, `package-lock.json` files: Contains required packages for npm
1. `tsconfig.json` file: Typesctipt configuration for the project
1. `src` folder: Contains source code
    1. `css` folder: Contains styling
    1. `ts` folder: Contains typescript classes/functions used in the project
        - `chart-base` folder: Abstract definition of charts
        - `charts` folder: Definition of concrete charts (Mostly Dataset-**In**dependent)
        - `charts-helpers` folder: Helpers classes used to manage charts in the home page, and process and pass data to charts
        - `main.ts` file: Entry point for the project

***Complete folder architecture:***
```
|   .env
|   .gitignore
|   index.html
|   package-lock.json
|   package.json
|   README.md
|   tsconfig.json
|   
+---data
|       olympic_games.csv
|       
+---public
|       favicon.svg
|       olympic-games-logo.png
|               
\---src
    |   vite-env.d.ts
    |   
    +---css
    |       style.css
    |       
    \---ts
        |   main.ts
        |   
        +---chart-base
        |       chart-configuration.ts
        |       chart.ts
        |       
        +---charts
        |       multi-line-chart.ts
        |       pie-chart.ts
        |       polar-area-chart.ts
        |       stacked-bar-chart.ts
        |       
        \---charts-helpers
                multi-line-chart-helper.ts
                pie-chart-helper.ts
                polar-area-chart-helper.ts
                stacked-bar-chart-helper.ts
```


## Contributing
Contributions are welcome! If you would like to contribute to this project, please fork the repository and submit a pull request.
