import * as d3 from 'd3';
import '/src/css/style.css';
import 'bootstrap';
import { StackedBarChartHelper } from './charts-helpers/stacked-bar-chart-helper';
import { MultiLineChartHelper } from './charts-helpers/multi-line-chart-helper';
import { PieChartHelper } from './charts-helpers/pie-chart-helper';
const datasetPath = import.meta.env.VITE_DATASET_PATH;
let rawData: any[];
const stackerBarChartHelper = new StackedBarChartHelper();
const multiLineChartHelper = new MultiLineChartHelper();
const pieChartHelper = new PieChartHelper();

d3.csv(datasetPath).then(data => {
    rawData = data.filter(d => d.Medal !== '');
    rawData = data.filter(d => d.Year !== '');
    rawData = data.filter(d => d.Medal !== '');
    stackerBarChartHelper.setData(rawData);
    stackerBarChartHelper.appendChart();

    multiLineChartHelper.setData(rawData);
    multiLineChartHelper.appendChart();

    pieChartHelper.setData(rawData);
    pieChartHelper.appendChart();

});