# Olympic Games Dashboard

## Project Details
- Data Visualization (DV) Course - Final Mini Project
    - Data Visualization using D3.js
- By: Almouhannad Hafez

## Table of Contents
- [Introduction](#introduction)
- [Features](#features)
- [How to Run](#how-to-run)
- [Technologies Used](#technologies-used)
- [Contributing](#contributing)

## Introduction
This project is a comprehensive dashboard that visualizes data from the Olympic Games using D3.js. It aims to provide insights into various aspects of the games, including medal counts, athlete performances, and historical trends.

## Features
- Interactive visualizations of Olympic data
- Filter options for different countries and events
- Easy navigation and user-friendly interface
- Reusable, clean, and self-documented code following design principles

## How to Run
To run this project locally, follow these steps:

1. **Clone the repository**
    ```bash
    git clone https://git.hiast.edu.sy/almohanad.hafez/dv-project.git Olympic-games-dashboard
    cd Olympic-games-dashboard
    ```    

2. **Install dependencies**    
    ```bash
    npm install
    ```

3. **Run the local server**
    ```bash
    npm run dev
    ```

4. **Open your browser** and navigate to `http://localhost:3000` to view the dashboard.

## Technologies Used
- **D3.js** for data visualization.
- **Node.js** for the server.
- **Vite** as the build tool and development server, offering fast hot module replacement and optimized builds for a smoother development experience.
- **HTML/CSS** for the frontend.
- **Bootstrap** for quick and easy styling of components.
- **npm** for package management.

## Contributing
Contributions are welcome! If you would like to contribute to this project, please fork the repository and submit a pull request.
