import { Chart } from './chart';
import { ChartFactory } from './ChartFactory';
import { ChartNames } from './ChartsNames';
import '/src/css/style.css';
import * as d3 from 'd3';

let data: any[] = [];
let chart: Chart;
d3.select("#charts-select-list")
    .on("change", function () {
        let selectedChart: string = d3.select(this).property('value');
        let chartInstance = ChartFactory.createChart(selectedChart);
        chart = chartInstance.instance;
        for (const chartName of ChartNames.CHARTS) {
            d3.select(`#${chartName}-container`).style("display", "none");
        }
        d3.select(`#${selectedChart}-container`).style("display", "block");

        /**
         * Load data from CSV file
         */
        d3.csv(chartInstance.datasetName)
            .then(inputData => {
                data = inputData;
                // Initialize chart
                chart.data = inputData;
                // Show chart
                chart.updateVis();
            })
            .catch(error => console.error(error));

    });


////////////////////// Events handlers //////////////////////

// #region Scatterplot
const selectedDifficulties: string[] = [];
function handleLevelSelectionEvent(element: any, difficulty: string) {
    const index = selectedDifficulties.indexOf(difficulty);
    if (index > -1) {
        // Difficulty is in the array, remove it
        selectedDifficulties.splice(index, 1);
        d3.select(element).style("opacity", 1);
    } else {
        // Difficulty is not in the array, add it
        selectedDifficulties.push(difficulty);
        d3.select(element).style("opacity", 0.5);
    }
    const filteredData = data.filter(item => !selectedDifficulties.includes(item.difficulty));
    chart.data = filteredData;
    chart.updateVis();
}
const difficulties = ["Easy", "Intermediate", "Difficult"]
// Add click event listeners for each difficulty level
for (const level of difficulties) {
    const id = `#scatterplot-legend-${level}`
    d3.select(id)
        .on("click", function () {
            handleLevelSelectionEvent(this, level);
        });
}
// #endregion

// #region LineChart
d3.select('#line-chart-year-input')
    .on('input', function () {
        // Get the current value of the input
        let value = d3.select(this).property('value');
        value = +value;
        const lineChartFilteredData = data.filter(item => item.date.getFullYear() >= value);
        chart.data = lineChartFilteredData;
        chart.updateVis();
    });
// #endregion

