
import { ChartConfiguration } from './chartConfiguration';
import { LineChart } from './lineChart';
import { Scatterplot } from './scatter';
import '/src/css/style.css';
import * as d3 from 'd3';

const selectedDifficulties: string[] = [];
let data: any[] = [];
const scatterplot = new Scatterplot(new ChartConfiguration("#scatterplot"));
function handleLevelSelectionEvent(element: any, difficulty: string) {
    const index = selectedDifficulties.indexOf(difficulty);
    if (index > -1) {
        // Difficulty is in the array, remove it
        selectedDifficulties.splice(index, 1);
        d3.select(element).style("opacity", 1);
    } else {
        // Difficulty is not in the array, add it
        selectedDifficulties.push(difficulty);
        d3.select(element).style("opacity", 0.5);
    }
    const filteredData = data.filter(item => !selectedDifficulties.includes(item.difficulty));
    scatterplot.data = filteredData;
    scatterplot.updateVis();
}
const difficulties = ["Easy", "Intermediate", "Difficult"]
// Add click event listeners for each difficulty level
for (const level of difficulties) {
    const id = `#scatterplot-legend-${level}`
    d3.select(id)
        .on("click", function () {
            handleLevelSelectionEvent(this, level);
        });
}
/**
 * Load data from CSV file asynchronously and render scatter plot
 */
d3.csv('/data/vancouver_trails.csv')
    .then(inputData => {
        // Convert strings to numbers
        inputData.forEach((d: any) => {
            d.time = +d.time;
            d.distance = +d.distance;
        });
        data = inputData;
        // Initialize chart
        scatterplot.data = inputData;
        // Show chart
        scatterplot.updateVis();
    })
    .catch(error => console.error(error));

/**
 * Load data from CSV file asynchronously and render scatter plot
 */

const lineChart = new LineChart(new ChartConfiguration("#line-chart"));
let lineChartData: any[];
d3.select('#line-chart-year-input')
    .on('input', function () {
        // Get the current value of the input
        let value = d3.select(this).property('value');
        value = +value;
        console.log(lineChartData[0].date);
        const lineChartFilteredData = lineChartData.filter(item => item.date.getFullYear() >= value);
        lineChart.data = lineChartFilteredData;
        lineChart.updateVis();

    });

d3.csv('/data/sp_500_index.csv')
    .then(inputData => {
        const dateParser = d3.timeParse("%Y-%m-%d");
        inputData.forEach((d: any) => {
            d.date = dateParser(d.date);
            d.close = +d.close;
        });

        lineChartData = inputData;
        lineChart.data = inputData;
        lineChart.updateVis();
    })
    .catch(error => console.error(error));
