import { AreaChart } from './areaChart';
import { ChartConfiguration } from './chartConfiguration';
import { Scatterplot } from './scatter';
import '/src/css/style.css';
import * as d3 from 'd3';

// const selectedDifficulties: string[] = [];
// let data: any[] = [];
// const scatterplot = new Scatterplot(new ChartConfiguration("#scatterplot"));
// function handleLevelSelectionEvent(element: any, difficulty: string) {
//     const index = selectedDifficulties.indexOf(difficulty);
//     if (index > -1) {
//         // Difficulty is in the array, remove it
//         selectedDifficulties.splice(index, 1);
//         d3.select(element).style("opacity", 1);
//     } else {
//         // Difficulty is not in the array, add it
//         selectedDifficulties.push(difficulty);
//         d3.select(element).style("opacity", 0.5);
//     }
//     const filteredData = data.filter(item => !selectedDifficulties.includes(item.difficulty));
//     scatterplot.data = filteredData;
//     scatterplot.updateVis();
// }
// const difficulties = ["Easy", "Intermediate", "Difficult"]
// // Add click event listeners for each difficulty level
// for (const level of difficulties) {
//     const id = `#scatterplot-legend-${level}`
//     d3.select(id)
//         .on("click", function () {
//             handleLevelSelectionEvent(this, level);
//         });
// }
// /**
//  * Load data from CSV file asynchronously and render scatter plot
//  */
// d3.csv('/data/vancouver_trails.csv')
//     .then(inputData => {
//         // Convert strings to numbers
//         inputData.forEach((d: any) => {
//             d.time = +d.time;
//             d.distance = +d.distance;
//         });
//         data = inputData;
//         // Initialize chart
//         scatterplot.data = inputData;
//         // Show chart
//         scatterplot.updateVis();
//     })
//     .catch(error => console.error(error));

/**
 * Load data from CSV file asynchronously and render scatter plot
 */
const areaChart = new AreaChart(new ChartConfiguration("#area-chart"));

d3.csv('/data/sp_500_index.csv')
    .then(inputData => {
        const dateParser = d3.timeParse("%Y-%m-%d");
        inputData.forEach((d: any) => {
            d.date = dateParser(d.date);
            d.close = +d.close;
        });

        areaChart.data = inputData;
        areaChart.updateVis();
    })
    .catch(error => console.error(error));

setTimeout(() => {
    const dateParser = d3.timeParse("%Y-%m-%d");
    let t: any = { date: '2025-10-29', close: 0 };
    t.date = dateParser(t.date);
    t.close = +t.close;
    areaChart.data.push(t);

    areaChart.updateVis();
}, 1000);