import { ChartConfiguration } from './chartConfiguration';
import { Scatterplot } from './scatter';
import '/src/css/style.css';
import * as d3 from 'd3';

/**
 * Load data from CSV file asynchronously and render scatter plot
 */
const scatterplot = new Scatterplot(new ChartConfiguration("#scatterplot"));
d3.csv('/data/vancouver_trails.csv')
    .then(data => {
        // Convert strings to numbers
        data.forEach((d: any) => {
            d.time = +d.time;
            d.distance = +d.distance;
        });
        // Initialize chart
        scatterplot.data = data;
        // Show chart
        scatterplot.updateVis();
    })
    .catch(error => console.error(error));
