import { Chart } from "./chart";
import { ChartConfiguration } from "./chartConfiguration";
import { ChartNames } from "./ChartsNames";
import { LineChart } from "./lineChart";
import { Scatterplot } from "./scatter";

export class ChartFactory {
    private static chartMap: Map<string, { instance: Chart; datasetName: string }> = new Map();
    private static scatterPlot: Chart = new Scatterplot(new ChartConfiguration("#scatterplot"));
    private static lineChart: Chart = new LineChart(new ChartConfiguration("#line-chart"));

    static {
        this.chartMap.set(ChartNames.SCATTER, { instance: this.scatterPlot, datasetName: "/data/vancouver_trails.csv" });
        this.chartMap.set(ChartNames.LINE_CHART, { instance: this.lineChart, datasetName: "/data/sp_500_index.csv" });
    }

    static createChart(chartName: string): { instance: Chart; datasetName: string } {
        const chartInstance = this.chartMap.get(chartName);
        if (chartInstance) {
            return chartInstance;
        }
        else throw new Error("No such chart");

    }
}
