/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LeaderElection
implements Watcher {
    private static final String ADDRESS = "192.168.181.136:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String ELECTION_NAMESPACE = "/election";
    private static final String LEADER_NODE_PREFIX = "leader-";
    private String currentNodePath;
    private String previousNodePath;
    private ZooKeeper zooKeeper;
    private Stat previousNodeStat;

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.volunteerForLeadership();
        leaderElection.electLeader();
        leaderElection.run();
    }

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ADDRESS, 3000, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            try {
                this.zooKeeper.wait();
            }
            catch (InterruptedException e) {
                System.out.println(e.getMessage());
            }
        }
        try {
            this.zooKeeper.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void volunteerForLeadership() throws InterruptedException, KeeperException {
        String znodeFullPath = this.zooKeeper.create("/election/leader-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        System.out.println("Created znode: " + znodeFullPath);
        this.currentNodePath = znodeFullPath.replace("/election/", "");
    }

    public void electLeader() throws InterruptedException, KeeperException {
        List<String> children = this.zooKeeper.getChildren(ELECTION_NAMESPACE, false);
        Collections.sort(children);
        int currentNodeIndex = children.indexOf(this.currentNodePath);
        if (currentNodeIndex == 0) {
            this.becomeLeader();
        } else {
            String previousNodeName = children.get(currentNodeIndex - 1);
            this.previousNodePath = "/election/" + previousNodeName;
            System.out.println("I'm not the leader, the leader is: " + children.get(0));
            this.watchPreviousNode();
        }
    }

    private void becomeLeader() throws KeeperException, InterruptedException {
        System.out.println("I'm the leader");
        String leaderData = "Leader: " + this.currentNodePath;
        this.zooKeeper.setData("/election/" + this.currentNodePath, leaderData.getBytes(), -1);
    }

    private void watchPreviousNode() throws KeeperException, InterruptedException {
        this.previousNodeStat = this.zooKeeper.exists(this.previousNodePath, this);
        if (this.previousNodeStat != null) {
            System.out.println("Watching previous node: " + this.previousNodePath);
        }
    }

    private void setData() throws InterruptedException, KeeperException {
        byte[] data = this.zooKeeper.getData(this.previousNodePath, this, this.previousNodeStat);
        String leaderData = new String(data);
        this.zooKeeper.setData("/election/" + this.currentNodePath, data, -1);
        System.out.println("Current leader: " + leaderData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to ZooKeeper");
                    break;
                }
                if (watchedEvent.getState() != Watcher.Event.KeeperState.Disconnected) break;
                System.out.println("Disconnected from ZooKeeper. Shutting down the program.");
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    this.zooKeeper.notifyAll();
                    break;
                }
            }
            case NodeDeleted: {
                if (!watchedEvent.getPath().equals(this.previousNodePath)) break;
                System.out.println("Previous leader node deleted. Attempting to become the new leader...");
                try {
                    this.electLeader();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
            case NodeDataChanged: {
                if (!watchedEvent.getPath().equals(this.previousNodePath)) break;
                System.out.println("Previous leader data changed. maybe we have a new leader .");
                try {
                    this.setData();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

