package org.example;

import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

import java.io.IOException;

public class LeaderElection implements Watcher {

    private static final String address = "192.168.181.136:2181";
    private static final int SESSION_TIMEOUT = 3000; //dead client
    private ZooKeeper zooKeeper;

    public static void main(String[] args) {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.run();

    }
    public void connectToZookeeper()  {
        try {
            this.zooKeeper = new ZooKeeper(address, SESSION_TIMEOUT, this);
        } catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
    public void run()  {
        synchronized (zooKeeper) {
            try {
                zooKeeper.wait();// wait for event
            } catch (InterruptedException e) {
                System.out.println(e.getMessage());
            }
        }
        try {
            zooKeeper.close();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None:
                if (watchedEvent.getState() == Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to ZooKeeper");
                }  else if (watchedEvent.getState() == Event.KeeperState.Disconnected) {
                    System.out.println("Disconnected from ZooKeeper. Shutting down the program.");
                    synchronized (zooKeeper) {
                        zooKeeper.notifyAll();
                    }
                }
                break;
        }
}}