package org.example;

import java.util.ArrayList;
import java.util.List;

public class Main {
    public static void main(String[] args) {

        FindPrimeNumbersWithMultiThreading(1,10000000,1);
        System.out.println("the number of prime numbers on range 10000000 to 20000000 using one thread ");
        FindPrimeNumbersWithMultiThreading(10000000,20000000,1);
        System.out.println("the number of prime numbers on range 20000000 to 30000000 using one thread");
        FindPrimeNumbersWithMultiThreading(20000000,30000000,1);
        System.out.println("the number of prime numbers on range 30000000 to 40000000 using one thread");
        FindPrimeNumbersWithMultiThreading(30000000,40000000,1);
        System.out.println("the number of prime numbers on range 40000000 to 50000000 using one thread");
        FindPrimeNumbersWithMultiThreading(40000000,50000000,1);
        System.out.println("the number of prime numbers on range 50000000 to 60000000 using one thread ");
        FindPrimeNumbersWithMultiThreading(50000000,60000000,1);
        System.out.println("the number of prime numbers on range 60000000 to 70000000 using one thread");
        FindPrimeNumbersWithMultiThreading(60000000,70000000,1);
        System.out.println("the number of prime numbers on range 70000000 to 80000000 using one thread");
        FindPrimeNumbersWithMultiThreading(70000000,80000000,1);
        System.out.println("the number of prime numbers on range 80000000 to 90000000 using one thread");
        FindPrimeNumbersWithMultiThreading(80000000,90000000,1);
        System.out.println("the number of prime numbers on range 90000000 to 100000000 using one thread");
        FindPrimeNumbersWithMultiThreading(90000000,100000000,1);


//
//        System.out.println("the number of prime numbers on range 1 to 25000000 using one thread");
//        FindPrimeNumbersWithMultiThreading(1,25000000,1);
//        System.out.println("the number of prime numbers on range 25000000 to 50000000 using one thread ");
//        FindPrimeNumbersWithMultiThreading(25000000,50000000,1);
//        System.out.println("the number of prime numbers on range 50000000 to 75000000 using one thread");
//        FindPrimeNumbersWithMultiThreading(50000000,75000000,1);
//        System.out.println("the number of prime numbers on range 75000000 to 100000000 using one thread");
//        FindPrimeNumbersWithMultiThreading(75000000,100000000,1);



//        System.out.println("the second case: increase the number of threads to 5 without change the search range ");
//        FindPrimeNumbersWithMultiThreading(1,100000000,5);
//        System.out.println("the second case: increase the number of threads to 10 without change the search range ");
//
//        FindPrimeNumbersWithMultiThreading(1,100000000,10);
//        System.out.println("the second case: increase the number of threads to 20 without change the search range ");
//
//        FindPrimeNumbersWithMultiThreading(1,100000000,20);

//        System.out.println("the third case: change search range to 50000000 without increase the number of threads");
//        FindPrimeNumbersWithMultiThreading(0,50000000,4);
//        System.out.println("the third case: change search range to 20000000 without increase the number of threads");
//        FindPrimeNumbersWithMultiThreading(0,20000000,4);
//        System.out.println("the third case: change search range to 10000000 without increase the number of threads");
//        FindPrimeNumbersWithMultiThreading(0,10000000,4);
    }
    static public void FindPrimeNumbersWithMultiThreading(int a, int b , int threadNumbers){
        List<Thread> threads = new ArrayList<>();
        int subRangeSize = ((b -a)+1)/threadNumbers;
        int remainingNumbers = (b - a + 1 )%threadNumbers;
        ArrayList<PrimeNumbersService> servers = new ArrayList<>();


        for (int i=0 ; i < threadNumbers; i++){
            int start = a + (i*subRangeSize);
            int end = a + subRangeSize -1;
            if (i == threadNumbers - 1) {
                end += remainingNumbers; // Add remaining numbers to the last segment
            }
            PrimeNumbersService x = new PrimeNumbersService(start , end);
            Thread thread = new Thread(x);
            threads.add(thread);
            servers.add(x);
            thread.start();
        }

        long startTime = System.currentTimeMillis();
        for(int i = 0; i<threadNumbers; i++){
            try {
                threads.get(i).join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        List<Integer> allPrimeNumbers = new ArrayList<>();
        for ( PrimeNumbersService service : servers){
            allPrimeNumbers.addAll(service.getPrimeNumbers());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total prime numbers found: " + allPrimeNumbers.size());
        System.out.println("Execution time: " + (endTime - startTime) + " milliseconds");
    }

}