#include "omp.h"
#include "stdlib.h"
#include "stdio.h"

int main() {
    
    double area = 0.0;

    for (int num_partitions = 10; num_partitions <= 10000000; num_partitions *= 100) {
        double total_width = 1.0;
        double partition_width = total_width / num_partitions;

        double start_time = omp_get_wtime(); 

        #pragma omp parallel for reduction(+:area) num_threads(4)
        for (int i = 0; i < num_partitions; ++i) {
            double x = (i + 0.5) * partition_width; 
            double height = x * x; 
            double partial_area = partition_width * height;

            area += partial_area; 
        }

        double end_time = omp_get_wtime(); 
        double execution_time = end_time - start_time;

        printf("For num_partitions: %d\n", num_partitions);
        printf("Total area under the curve: %f\n", area);
        printf("Execution time: %f seconds\n", execution_time);

        area = 0.0; 
    }

    return 0;
}