#include <stdio.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
   
    double total_width = 1.0; 
    
    double area = 0.0; 

    int num_processes, process_rank;
    double start_time, end_time, execution_time;

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &num_processes);
    MPI_Comm_rank(MPI_COMM_WORLD, &process_rank);
    for ( int num_partitions = 10; num_partitions <=10000000; num_partitions *= 100)
    {
        double partition_width = total_width / num_partitions;
       if (process_rank == 0) {
        start_time = MPI_Wtime();
       }

    int local_start = (num_partitions / num_processes) * process_rank;
    int local_end;
    
    if (process_rank < num_partitions % num_processes) {
        local_end = local_start + (num_partitions / num_processes) + 1;
    } else {
        local_end = local_start + (num_partitions / num_processes);
    }

    double local_area = 0.0;
    for (int i = local_start; i < local_end; ++i) {
        double x = (i + 0.5) * partition_width; 
        double height = x * x;
        double partial_area = partition_width * height; 

        local_area += partial_area; 
    }

    MPI_Reduce(&local_area, &area, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);

    if (process_rank == 0) {
        end_time = MPI_Wtime(); 
        execution_time = end_time - start_time;
        printf("for num_partitions: %d\n", num_partitions);
        printf("Total area under the curve: %f\n", area);
        printf("Execution time: %f seconds\n", execution_time);
    }
    
    }
   

    MPI_Finalize();

    return 0;
}
