package org.example.resources;

import org.example.models.Invoice;
import org.example.models.User;
import org.example.repositories.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@RestController
@RequestMapping("/users")
public class UserResource {
    private static final Logger log = LoggerFactory.getLogger(UserResource.class);

    UserRepository userRepository = new UserRepository();
    @Autowired
    RestTemplate restTemplate;
    @GetMapping("/getUnPaidInvoices/{userId}")
    public List<Invoice> getUnPaidInvoices(@PathVariable("userId") String userId){
        if(userRepository.exist(userId))   {
            List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getUnPaidInvoicesForSpecificUser/" + userId, Invoice[].class));
            System.out.println("I am in latakia zone");
            log.info("Got unpaid invoices for user has "+userId+ " userId");
            System.out.println("Got all unpaid invoices for user has "+userId+ " userId");
            return invoices;
        }
        return null;
    }
    @PostMapping("/payInvoice/{userId}/{invoiceId}")
    public boolean payInvoice(@PathVariable("userId") String userId,@PathVariable("invoiceId") String invoiceId){
        User user = new User();
        if(userRepository.exist(userId)){
            user = userRepository.getUser(userId);
            Invoice invoice = restTemplate.getForObject("http://invoicing-service/invoices/getInvoiceDetails/" + invoiceId, Invoice.class);
            if(user.getBalance() >= invoice.getValue()){
                user.setBalance(user.getBalance() - invoice.getValue());
                String url = "http://invoicing-service/invoices/updateInvoiceStatus/" + invoiceId;
                ResponseEntity<Boolean> response = restTemplate.exchange(url, HttpMethod.POST, null, Boolean.class);
                boolean status = response.getBody();
                userRepository.updateUser(user);
                System.out.println("I am in latakia zone");
                log.info("paid invoice with "+invoiceId+ " invoiceId for user has "+userId+" userId");
                System.out.println("paid invoice with "+invoiceId+ " invoiceId for user has "+userId+" userId");
                return status;
            }
            else{
                System.out.println("you do not have enough balance!!!");
                return false;
            }

        }
        else {
            System.out.println("user does not exist!!");
            return false;
        }
    }
    @GetMapping("/getAllUsersHaveUnPaidInvoices")
    public HashMap<User,Invoice> getAllUsersHaveUnPaidInvoices(){
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getUnPaidInvoices", Invoice[].class));
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());
            User user = new User();
            user = userRepository.getUser(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        System.out.println("I am in latakia zone");
        log.info("Got all users have unPaid invoices");
        System.out.println("Got all users have unPaid invoices");
        return userInvoiceHashMap;
    }
    @GetMapping("/getAllUsersHavePaidInvoices")
    public HashMap<User,Invoice> getAllUsersHavePaidInvoices(){
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getPaidInvoices", Invoice[].class));

        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());
            User user = new User();
            user = userRepository.getUser(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        System.out.println("I am in latakia zone");
        log.info("Got all users have paid invoices");
        System.out.println("Got all users have paid invoices");
        return userInvoiceHashMap;
    }
}
