package org.example.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.example.models.Invoice;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ExternalAPI {
    public static Invoice getInvoiceDetails(String invoiceId) throws IOException {
        String prompt = "{\n" +
                "    \"prompt\": \"generate just one random json object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is " + invoiceId + ", please just return this object without any words else\"\n" +
                "}";
        String response = sendRequestToAPI(prompt);
        String jsonString = "";
        int firstIndex = response.toString().indexOf("{");
        int endIndex = response.toString().indexOf("}");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Gson gson = new Gson();
        Invoice invoice = gson.fromJson(jsonString, Invoice.class);
        System.out.println(invoice.toString());
        return invoice;
    }
     static public List<Invoice> getUnPaidInvoicesForSpecificUser(String userId){
         String prompt = "{\n" +
                 "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is unique and userId is " + userId+ ", please just return this list of objects without any words else\"\n" +
                 "}";
         ArrayList<Invoice> invoices = new ArrayList<Invoice>();
         String response = null;
         response = sendRequestToAPI(prompt);
         String jsonString = "";
         int firstIndex = response.toString().indexOf("[");
         int endIndex = response.toString().indexOf("]");
         jsonString = response.toString().substring(firstIndex, endIndex + 1);
         Type listType = new TypeToken<List<Invoice>>() {}.getType();
         Gson gson = new Gson();
         invoices = gson.fromJson(jsonString, listType);
         return invoices;
    }
    static public List<Invoice> getUnPaidInvoices(){
        String prompt = "{\n" +
                "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is unique and userId is between 1 to 4, please just return this list of objects without any words else\"\n" +
                "}";
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        String response = null;
        response = sendRequestToAPI(prompt);
        String jsonString = "";
        int firstIndex = response.toString().indexOf("[");
        int endIndex = response.toString().indexOf("]");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Type listType = new TypeToken<List<Invoice>>() {}.getType();
        Gson gson = new Gson();
        invoices = gson.fromJson(jsonString, listType);
        return invoices;
    }
    static public List<Invoice> getPaidInvoices(){
        String prompt = "{\n" +
                "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is true and value is double and invoiceId is unique and userId is between 1 to 4, please just return this list of objects without any words else\"\n" +
                "}";
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        String response = null;
        response = sendRequestToAPI(prompt);
        String jsonString = "";
        int firstIndex = response.toString().indexOf("[");
        int endIndex = response.toString().indexOf("]");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Type listType = new TypeToken<List<Invoice>>() {}.getType();
        Gson gson = new Gson();
        invoices = gson.fromJson(jsonString, listType);
        return invoices;
    }


    public static String sendRequestToAPI(String prompt) {
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://fumes-api.onrender.com/llama3";
        org.springframework.http.HttpHeaders headers = new org.springframework.http.HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> requestEntity = new HttpEntity<>(prompt, headers);
        ResponseEntity<String> responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class);
        String response = responseEntity.getBody();
        System.out.println(response);
        return response;
    }
}
