package org.example.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.example.models.Invoice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ExternalAPI {
    public static Invoice getInvoiceDetails(String invoiceId) throws IOException {
        String prompt = "{\n" +
                "    \"prompt\": \"generate just one random json object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is " + invoiceId + ", please just return this object without any words else\"\n" +
                "}";
        String response = sendRequestToAPI(prompt);
        System.out.println(response.toString());
        String jsonString = "";
        int firstIndex = response.toString().indexOf("{");
        int endIndex = response.toString().indexOf("}");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Gson gson = new Gson();
        Invoice invoice = gson.fromJson(jsonString, Invoice.class);
        System.out.println(invoice.toString());
        return invoice;
    }
     static public List<Invoice> getUnPaidInvoicesForSpecificUser(String userId){
         String prompt = "{\n" +
                 "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is unique and userId is " + userId+ ", please just return this list of objects without any words else\"\n" +
                 "}";
         ArrayList<Invoice> invoices = new ArrayList<Invoice>();
         String response = null;
         try {
             response = sendRequestToAPI(prompt);
         } catch (IOException e) {
             throw new RuntimeException(e);
         }

         String jsonString = "";
         int firstIndex = response.toString().indexOf("[");
         int endIndex = response.toString().indexOf("]");
         jsonString = response.toString().substring(firstIndex, endIndex + 1);
         Type listType = new TypeToken<List<Invoice>>() {}.getType();
         Gson gson = new Gson();
         invoices = gson.fromJson(jsonString, listType);
         return invoices;
    }
    static public List<Invoice> getUnPaidInvoices(){
        String prompt = "{\n" +
                "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is false and value is double and invoiceId is unique, please just return this list of objects without any words else\"\n" +
                "}";
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        String response = null;
        try {
            response = sendRequestToAPI(prompt);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        String jsonString = "";
        int firstIndex = response.toString().indexOf("[");
        int endIndex = response.toString().indexOf("]");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Type listType = new TypeToken<List<Invoice>>() {}.getType();
        Gson gson = new Gson();
        invoices = gson.fromJson(jsonString, listType);
        return invoices;
    }
    static public List<Invoice> getPaidInvoices(){
        String prompt = "{\n" +
                "    \"prompt\": \"generate list of  random json objects each object contains these attributes: value, status, description, userID, invoiceID. where status is true and value is double and invoiceId is unique, please just return this list of objects without any words else\"\n" +
                "}";
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        String response = null;
        try {
            response = sendRequestToAPI(prompt);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        String jsonString = "";
        int firstIndex = response.toString().indexOf("[");
        int endIndex = response.toString().indexOf("]");
        jsonString = response.toString().substring(firstIndex, endIndex + 1);
        Type listType = new TypeToken<List<Invoice>>() {}.getType();
        Gson gson = new Gson();
        invoices = gson.fromJson(jsonString, listType);
        return invoices;
    }

    public static String sendRequestToAPI(String prompt) throws IOException{
        URL url = new URL("https://fumes-api.onrender.com/llama3");
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        String requestBody = prompt;
        try (OutputStream outputStream = connection.getOutputStream()) {
            byte[] input = requestBody.getBytes("utf-8");
            outputStream.write(input, 0, input.length);
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"))) {
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e){
            System.out.println(e.getMessage());
        }
        connection.disconnect();
        System.out.println(response.toString());
        return response.toString();
    }

}
