package org.example.resources;

import org.example.models.Invoice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/invoices")
public class InvoiceResource {
    @Autowired
    RestTemplate restTemplate;
    @GetMapping("/getInvoiceDetails/{invoiceId}")
    public Invoice getInvoiceDetails(@PathVariable("invoiceId") String invoiceId){

        Invoice invoice = null;
        try {
            invoice = ExternalAPI.getInvoiceDetails(invoiceId);
        } catch (IOException e){
            throw new RuntimeException(e);
        }
        return invoice;
    }

    @GetMapping("/getUnPaidInvoicesForSpecificUser/{userId}")
    public List<Invoice> getUnPaidInvoicesForSpecificUser(@PathVariable("userId") String userId){
        List<Invoice> inv = new ArrayList<>();
        inv = ExternalAPI.getUnPaidInvoicesForSpecificUser(userId);
        return inv;
    }
    @PostMapping("/updateInvoiceStatus/{invoiceId}")
    public boolean updateInvoiceStatus(@PathVariable("invoiceId") String invoiceId){
        /* here some logic like get invoice from database and set the status to true */
        return true;
    }
    @GetMapping("/getUnPaidInvoices")
    public List<Invoice> getUnPaidInvoices(){
        List<Invoice> invoices = new ArrayList<Invoice>();
        invoices = ExternalAPI.getUnPaidInvoices();
        return invoices;
    }
    @GetMapping("/getPaidInvoices")
    public List<Invoice> getPaidInvoices(){
        List<Invoice> invoices = new ArrayList<Invoice>();
        invoices = ExternalAPI.getPaidInvoices();
        return invoices;
    }
}
