package org.example.resources;

import org.example.models.Invoice;
import org.example.models.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@RestController
@RequestMapping("/users")
public class UserResource {
    @Autowired
    RestTemplate restTemplate;
    
    @GetMapping("/getUnPaidInvoices/{userId}")
    public List<Invoice> getUnPaidInvoices(@PathVariable("userId") String userId){
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getUnPaidInvoicesForSpecificUser/" + userId, Invoice[].class));
        return invoices;
    }
    @PostMapping("/payInvoice/{userId}/{invoiceId}")
    public boolean payInvoice(@PathVariable("userId") String userId,@PathVariable("invoiceId") String invoiceId){
        User user = new User(userId,"Ali",5000.0);
        Invoice invoice = restTemplate.getForObject("http://localhost:8081/invoices/getInvoiceDetails/" + invoiceId, Invoice.class);
        if(user.getBalance() >= invoice.getValue()){
            user.setBalance(user.getBalance() - invoice.getValue());
            String url = "http://localhost:8081/invoices/updateInvoiceStatus/" + invoiceId;
            ResponseEntity<Boolean> response = restTemplate.exchange(url, HttpMethod.POST, null, Boolean.class);
            boolean status = response.getBody();
            return status;
        }
        else{
            System.out.println("you do not have enough balance!!!");
            return false;
        }
    }
    @GetMapping("/getAllUsersHaveUnPaidInvoices")
    public HashMap<User,Invoice> getAllUsersHaveUnPaidInvoices(){
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getUnPaidInvoices", Invoice[].class));
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());

            User user = new User();
            user.setBalance(500.0);
            user.setName("Ali"+invoice.getUserID());
            user.setUserId(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
    @GetMapping("/getAllUsersHavePaidInvoices")
    public HashMap<User,Invoice> getAllUsersHavePaidInvoices(){

        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getPaidInvoices", Invoice[].class));

        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());

            User user = new User();
            user.setBalance(500.0);
            user.setName("Ali"+invoice.getUserID());
            user.setUserId(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
}
