package org.example.resources;

import org.example.models.Invoice;
import org.example.models.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@RestController
@RequestMapping("/users")
public class UserResource {
    @Autowired
    RestTemplate restTemplate;
    
    @GetMapping("/getUnPaidInvoices/{userId}")
    public List<Invoice> getUnPaidInvoices(@PathVariable("userId") String userId){
//        Invoice inv1 = new Invoice("1", "1","ssssssd",false,55.0);
//        Invoice inv2 = new Invoice("2", "1","dddddddddd",false,545.0);
//
//        System.out.println(userId);
//
//        ArrayList<Invoice> inv = new ArrayList<Invoice>();
//        inv.add(inv1);
//        inv.add(inv2);
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getUnPaidInvoicesForSpecificUser/" + userId, Invoice[].class));
        return invoices;
    }
    @PostMapping("/payInvoice/{userId}/{invoiceId}")
    public boolean payInvoice(@PathVariable("userId") String userId,@PathVariable("invoiceId") String invoiceId){
        User user = new User("1","Ali",500.0);
//        Invoice invoice = new Invoice("2", "1","dddddddddd",false,545.0);
        Invoice invoice = restTemplate.getForObject("http://localhost:8081/invoices/getInvoiceDetails/" + invoiceId, Invoice.class);
        if(user.getBalance() >= invoice.getValue()){
            user.setBalance(user.getBalance() - invoice.getValue());
            // boolean status = restTemplate.postForObject("http://localhost:8081/invoices/updateInvoiceStatus/" + invoiceId, boolean.class);
            String url = "http://localhost:8081/invoices/updateInvoiceStatus/" + invoiceId;
            ResponseEntity<Boolean> response = restTemplate.exchange(url, HttpMethod.POST, null, Boolean.class);
            boolean status = response.getBody();
            return status;
        }
        else{
            System.out.println("you do not have enough balance!!!");
            return false;
        }
    }
    @GetMapping("/getAllUsersHaveUnPaidInvoices")
    public HashMap<User,Invoice> getAllUsersHaveUnPaidInvoices(){
  //      User user = new User("1","Ali",500.0);
//        User user2 = new User("2","Hasan",5000.0);
//        Invoice invoice1 = new Invoice("2", "1","dddddddddd",false,545.0);
//        Invoice invoice2 = new Invoice("3", "2","dddddddddd",false,545.0);
//        ArrayList<Invoice> inv = new ArrayList<Invoice>();
//        inv.add(invoice1);
//        inv.add(invoice2);
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getUnPaidInvoices", Invoice[].class));
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());

            User user = new User();
            user.setBalance(500.0);
            user.setName("Ali"+invoice.getUserID());
            user.setUserId(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
    @GetMapping("/getAllUsersHavePaidInvoices")
    public HashMap<User,Invoice> getAllUsersHavePaidInvoices(){
   //     User user = new User("1","Ali",500.0);
//        User user2 = new User("2","Hasan",5000.0);
//        Invoice invoice1 = new Invoice("2", "1","dddddddddd",true,545.0);
//        Invoice invoice2 = new Invoice("3", "2","dddddddddd",true,545.0);
//        ArrayList<Invoice> inv = new ArrayList<Invoice>();
//        inv.add(invoice1);
//        inv.add(invoice2);
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://localhost:8081/invoices/getPaidInvoices", Invoice[].class));

        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());

            User user = new User();
            user.setBalance(500.0);
            user.setName("Ali"+invoice.getUserID());
            user.setUserId(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
}
