package org.example.repositories;

import com.google.gson.Gson;
import org.example.models.User;
import redis.clients.jedis.Jedis;

public class UserRepository {
    private Jedis jedis;
    private Gson gson;

    public UserRepository() {
        jedis = new Jedis("localhost", 6379);
        gson = new Gson();
    }
    public boolean exist(String userId){
        if (jedis.exists(userId)) {
            return true;
        }
        return false;
    }

    public void addUser(User user) {

        String userJson = convertToJson(user);
        jedis.set(user.getUserId(), userJson);
    }

    public User getUser(String userId) {
        String userJson = jedis.get(userId);
        return convertFromJson(userJson,userId);
    }

    public void updateUser(User user) {

        if (jedis.exists(user.getUserId())) {
            String userJson = convertToJson(user);
            jedis.set(user.getUserId(), userJson);
        }
    }

    public void deleteUser(String userId) {
        jedis.del(userId);
    }

    private String convertToJson(User user) {
        UserJsonData userJsonData = new UserJsonData();
        userJsonData.setName(user.getName());
        userJsonData.setBalance(user.getBalance());
        return gson.toJson(userJsonData);
    }

    private User convertFromJson(String userJson,String userId) {
        UserJsonData userJsonData = gson.fromJson(userJson, UserJsonData.class);
        User user = new User();
        user.setUserId(userId);
        user.setName(userJsonData.getName());
        user.setBalance(userJsonData.getBalance());
        return user;
    }
    private static class UserJsonData {
        private String name;
        private double balance;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getBalance() {
            return balance;
        }

        public void setBalance(double balance) {
            this.balance = balance;
        }
    }

}
