package org.example.resources;

import org.example.models.Invoice;
import org.example.models.User;
import org.example.repositories.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@RestController
@RequestMapping("/users")
public class UserResource {
    UserRepository userRepository = new UserRepository();
    @Autowired
    RestTemplate restTemplate;
    @GetMapping("/getUnPaidInvoices/{userId}")
    public List<Invoice> getUnPaidInvoices(@PathVariable("userId") String userId){
        if(userRepository.exist(userId))   {
            List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getUnPaidInvoicesForSpecificUser/" + userId, Invoice[].class));
            return invoices;
        }
        return null;
    }
    @PostMapping("/payInvoice/{userId}/{invoiceId}")
    public boolean payInvoice(@PathVariable("userId") String userId,@PathVariable("invoiceId") String invoiceId){
        User user = new User();
        if(userRepository.exist(userId)){
            user = userRepository.getUser(userId);
            Invoice invoice = restTemplate.getForObject("http://invoicing-service/invoices/getInvoiceDetails/" + invoiceId, Invoice.class);
            if(user.getBalance() >= invoice.getValue()){
                user.setBalance(user.getBalance() - invoice.getValue());
                String url = "http://invoicing-service/invoices/updateInvoiceStatus/" + invoiceId;
                ResponseEntity<Boolean> response = restTemplate.exchange(url, HttpMethod.POST, null, Boolean.class);
                boolean status = response.getBody();
                userRepository.updateUser(user);
                return status;
            }
            else{
                System.out.println("you do not have enough balance!!!");
                return false;
            }

        }
        else {
            System.out.println("user does not exist!!");
            return false;
        }
    }
    @GetMapping("/getAllUsersHaveUnPaidInvoices")
    public HashMap<User,Invoice> getAllUsersHaveUnPaidInvoices(){
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getUnPaidInvoices", Invoice[].class));
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());
            User user = new User();
//            user.setBalance(500.0);
//            user.setName("Ali"+invoice.getUserID());
//            user.setUserId(invoice.getUserID());
            user = userRepository.getUser(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
    @GetMapping("/getAllUsersHavePaidInvoices")
    public HashMap<User,Invoice> getAllUsersHavePaidInvoices(){
        HashMap<User,Invoice> userInvoiceHashMap = new HashMap<>();
        List<Invoice> invoices = Arrays.asList(restTemplate.getForObject("http://invoicing-service/invoices/getPaidInvoices", Invoice[].class));

        for (Invoice invoice: invoices)
        {
            System.out.println(invoice.toString());
            User user = new User();
//            user.setBalance(500.0);
//            user.setName("Ali"+invoice.getUserID());
//            user.setUserId(invoice.getUserID());
            user = userRepository.getUser(invoice.getUserID());
            userInvoiceHashMap.put(user,invoice);
        }
        return userInvoiceHashMap;
    }
}
