package org.example.resources;

import org.example.models.Invoice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/invoices")
public class InvoiceResource {

    private static final Logger log = LoggerFactory.getLogger(InvoiceResource.class);
    @Autowired
    RestTemplate restTemplate;
    @GetMapping("/getInvoiceDetails/{invoiceId}")
    public Invoice getInvoiceDetails(@PathVariable("invoiceId") String invoiceId){

        Invoice invoice = null;
        try {
            invoice = ExternalAPI.getInvoiceDetails(invoiceId);
            System.out.println("I am in latakia zone");
            System.out.println("Got invoice details it's Id is "+ invoiceId);
            System.out.println("Got invoice details it's Id is "+ invoiceId);
            System.out.println(invoice.toString());
        } catch (IOException e){
            throw new RuntimeException(e);
        }
        return invoice;
    }

    @GetMapping("/getUnPaidInvoicesForSpecificUser/{userId}")
    public List<Invoice> getUnPaidInvoicesForSpecificUser(@PathVariable("userId") String userId){
        List<Invoice> inv = new ArrayList<>();
        inv = ExternalAPI.getUnPaidInvoicesForSpecificUser(userId);
        System.out.println("I am in latakia zone");
        log.info("Got unpaid invoices for user has "+userId+ " userId");
        System.out.println("Got unpaid invoices for user has "+userId+ " userId");
        return inv;
    }
    @PostMapping("/updateInvoiceStatus/{invoiceId}")
    public boolean updateInvoiceStatus(@PathVariable("invoiceId") String invoiceId){
        /* here some logic like get invoice from database and set the status to true */
        System.out.println("I am in latakia zone");
        log.info("mark the invoice which has "+invoiceId+" invoiceId status as true (paid)");
        System.out.println("mark the invoice which has "+invoiceId+" invoiceId status as true (paid)");
        return true;
    }
    @GetMapping("/getUnPaidInvoices")
    public List<Invoice> getUnPaidInvoices(){
        List<Invoice> invoices = new ArrayList<Invoice>();
        invoices = ExternalAPI.getUnPaidInvoices();
        System.out.println("I am in latakia zone");
        log.info("Got all unpaid invoices");
        System.out.println("Got all unpaid invoices");
        return invoices;
    }
    @GetMapping("/getPaidInvoices")
    public List<Invoice> getPaidInvoices(){
        List<Invoice> invoices = new ArrayList<Invoice>();
        invoices = ExternalAPI.getPaidInvoices();
        System.out.println("I am in latakia zone");
        log.info("Got all paid invoices");
        System.out.println("Got all paid invoices");
        return invoices;
    }
}
