import 'package:flutter/material.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Widgets/interview_widget.dart';
import '../../data/Common/interview.dart';
import '../company/search_in_my_interviews_screen.dart';

// ignore: must_be_immutable
class ShowInterviewsScreen extends StatefulWidget {
  int id;

  ShowInterviewsScreen({super.key, required this.id});

  @override
  State<ShowInterviewsScreen> createState() => _ShowInterviewsScreenState();
}

class _ShowInterviewsScreenState extends State<ShowInterviewsScreen> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              actions: [
                Padding(
                  padding: const EdgeInsets.only(right: 8.0),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      IconButton(
                        icon: const Icon(
                          Icons.search,
                          size: 25,
                          color: Colors.black,
                        ),
                        onPressed: () {
                          Navigator.push(
                              context,
                              MaterialPageRoute(
                                  builder: (context) =>
                                      SearchInMyInterviewsScreen(
                                          id: widget.id)));
                        },
                      ),
                    ],
                  ),
                ),
              ],
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 25,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              title: const Text("Job Interviews"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder(
                future: fetch.getAllInterviewsByJobId(widget.id),
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<Interview>? interviews = snapshot.data;
                    return ListView.builder(
                      itemCount: interviews!.length,
                      itemBuilder: (context, index) {
                        Interview interview = interviews[index];
                        return InterviewWidget(interview: interview);
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
