import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../Services/Common/new_notification_manager.dart';
import '../UI/Notification/show_my_notification_screen.dart';
import 'new_notification_widget.dart';

// ignore: must_be_immutable
class ConsumerWidget extends StatefulWidget {
  const ConsumerWidget({
    super.key,
  });

  @override
  State<ConsumerWidget> createState() => _ConsumerWidgetState();
}

class _ConsumerWidgetState extends State<ConsumerWidget> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<NewNotificationManager>(
      builder: (context, notificationManager, _) {
        if (notificationManager.hasNewNotification) {
          return NewNotificationWidget(
            notificationCount: notificationManager.notificationCount,
            onDismiss: () {
              notificationManager.dismiss();
            },
            onDetails: () {
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => const ShowMyNotificationScreen(),
                ),
              );
              notificationManager.dismiss();
            },
          );
        } else {
          return const SizedBox.shrink();
        }
      },
    );
  }
}
