import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';

import '../UI/jobseeker/show_company_profile_screen.dart';
import '../data/Company/company.dart';

// ignore: must_be_immutable
class CompanyWidget extends StatefulWidget {
  final Company company;

  const CompanyWidget({
    super.key,
    required this.company,
  });

  @override
  State<CompanyWidget> createState() => _CompanyWidgetState();
}

class _CompanyWidgetState extends State<CompanyWidget> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.white24,
        child: ListTile(
          onLongPress: () {},
          onTap: () {
            Navigator.push(
                context,
                MaterialPageRoute(
                    builder: (context) => ShowCompanyProfileScreen(
                          id: widget.company.id,
                        )));
          },
          leading: Container(
              width: 100,
              height: 150,
              padding: const EdgeInsets.only(right: 8.0),
              decoration: const BoxDecoration(
                border: Border(right: BorderSide(width: 1)),
              ),
              child: Expanded(
                child: Image.network(
                  '$myUrl/${widget.company.image}',
                  fit: BoxFit.fill,
                ),
              )),
          title: Text(widget.company.name,
              style: const TextStyle(
                  color: Colors.amber,
                  fontSize: 18,
                  fontWeight: FontWeight.bold),
              maxLines: 2,
              overflow: TextOverflow.ellipsis),
          subtitle: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(widget.company.description,
                  style: const TextStyle(
                    color: Colors.black,
                    fontSize: 15,
                  ),
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
            ],
          ),
          trailing: const Icon(
            Icons.keyboard_arrow_right,
            color: Colors.black,
            size: 30,
          ),
        ),
      ),
    );
  }
}
