import 'package:flutter/material.dart';

import '../Services/global_variables.dart';
import '../UI/Common/about_screen.dart';
import '../UI/Common/change_your_password.dart';
import '../UI/Common/users_screen.dart';
import '../UI/Company/company_profile_screen.dart';
import '../UI/Company/edit_company_information_screen.dart';
import '../UI/Company/jobs_setting.dart';
import '../UI/Company/upload_job_screen.dart';
import '../UI/jobseeker/edit_personal_information_screen.dart';
import '../UI/jobseeker/my_interviews_screen.dart';
import '../UI/jobseeker/my_jobs_screen.dart';
import '../UI/jobseeker/profile_screen.dart';
import '../data/Common/person.dart';
import '../data/Company/company.dart';
import '../data/jobseeker/cv.dart';
import '../logic/fetch.dart';

// ignore: must_be_immutable
class AppDrawerWidget extends StatelessWidget {
  Person person;

  AppDrawerWidget({super.key, required this.person});

  Widget buildListTile({
    required String title,
    required IconData icon,
  }) {
    return ListTile(
      leading: Icon(
        icon,
        size: 30,
        color: Colors.amber,
      ),
      title: Text(
        title,
        style: const TextStyle(
          fontFamily: 'ElMessiri',
          fontSize: 20,
        ),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Drawer(
      backgroundColor: Colors.blueGrey,
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Padding(
                padding: const EdgeInsets.all(10.0),
                child: Container(
                  width: MediaQuery.of(context).size.width * 0.3,
                  height: MediaQuery.of(context).size.width * 0.3,
                  decoration: BoxDecoration(
                    border: Border.all(width: 2, color: Colors.amber),
                    shape: BoxShape.circle,
                  ),
                  child: ClipOval(
                    child: Image.network(
                      '$myUrl/${person.image}',
                      fit: BoxFit.fill,
                    ),
                  ),
                ),
              ),
              Padding(
                padding: const EdgeInsets.all(10.0),
                child: Text(person.name),
              ),
              Padding(
                padding: const EdgeInsets.all(10.0),
                child: Text(person.email),
              ),
              const SizedBox(
                height: 20,
                child: Divider(
                  thickness: 1,
                ),
              ),
              GestureDetector(
                onTap: () {
                  identifier.iscompany == true
                      ? Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) =>
                                  const CompanyProfileScreen()))
                      : Navigator.pushReplacement(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const ProfileScreen()));
                },
                child: buildListTile(
                  title: "Profile",
                  icon: Icons.person,
                ),
              ),
              const Divider(
                thickness: 1,
              ),
              identifier.iscompany == true
                  ? GestureDetector(
                      onTap: () {
                        Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const UploadJobScreen()));
                      },
                      child:
                          buildListTile(title: "Upload job", icon: Icons.add),
                    )
                  : GestureDetector(
                      onTap: () {
                        Navigator.push(
                            context,
                            MaterialPageRoute(
                                builder: (context) =>
                                    const MyInterviewsScreen()));
                      },
                      child: buildListTile(
                        title: "My interviews",
                        icon: Icons.my_library_books,
                      ),
                    ),
              const Divider(
                thickness: 1,
              ),
              GestureDetector(
                onTap: () {
                  identifier.iscompany == true
                      ? Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const JobsSetting()))
                      : Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const MyJobsScreen()));
                },
                child: buildListTile(
                  title: "My jobs",
                  icon: Icons.my_library_books,
                ),
              ),
              const Divider(
                thickness: 1,
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => const ChangeYourPassword()));
                },
                child: buildListTile(
                  title: "Change password",
                  icon: Icons.key,
                ),
              ),
              const Divider(
                thickness: 1,
              ),
              GestureDetector(
                onTap: () {
                  identifier.iscompany == true
                      ? Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => FutureBuilder<Company>(
                              future: fetch.fetchCompany(),
                              builder: (context, snapshot) {
                                if (snapshot.connectionState ==
                                    ConnectionState.waiting) {
                                  return SafeArea(
                                    child: Container(
                                        decoration: const BoxDecoration(
                                            gradient: LinearGradient(
                                                colors: [
                                                  Colors.cyan,
                                                  Colors.greenAccent
                                                ],
                                                begin: Alignment.centerLeft,
                                                end: Alignment.centerRight,
                                                stops: [0.2, 0.9])),
                                        child: const Center(
                                            child:
                                                CircularProgressIndicator())),
                                  );
                                } else if (snapshot.hasError) {
                                  return Text("Error: ${snapshot.error}");
                                } else {
                                  return EditCompanyInformationScreen(
                                      company: snapshot.data);
                                }
                              },
                            ),
                          ),
                        )
                      : Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => FutureBuilder<CV>(
                              future: fetch.fetchCV(),
                              builder: (context, snapshot) {
                                if (snapshot.connectionState ==
                                    ConnectionState.waiting) {
                                  return SafeArea(
                                    child: Container(
                                        decoration: const BoxDecoration(
                                            gradient: LinearGradient(
                                                colors: [
                                                  Colors.cyan,
                                                  Colors.greenAccent
                                                ],
                                                begin: Alignment.centerLeft,
                                                end: Alignment.centerRight,
                                                stops: [0.2, 0.9])),
                                        child: const Center(
                                            child:
                                                CircularProgressIndicator())),
                                  );
                                } else if (snapshot.hasError) {
                                  return Text("Error: ${snapshot.error}");
                                } else {
                                  return EditPersonalInformationScreen(
                                      cv: snapshot.data);
                                }
                              },
                            ),
                          ),
                        );
                },
                child: buildListTile(
                  title: "Edit profile",
                  icon: Icons.edit,
                ),
              ),
              const Divider(
                thickness: 1,
              ),
              GestureDetector(
                  onTap: () {
                    Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => const UsersScreen()));
                  },
                  child: buildListTile(title: "Users", icon: Icons.group)),
              const Divider(
                thickness: 1,
              ),
            ],
          ),
          Column(children: [
            const SizedBox(
              height: 20,
              child: Divider(
                thickness: 1,
              ),
            ),
            Padding(
              padding: const EdgeInsets.all(10.0),
              child: Row(
                children: [
                  const Text("Job Portal app -   "),
                  InkWell(
                      onTap: () {
                        Navigator.push(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const AboutScreen()));
                      },
                      child: const Text(
                        "About",
                        style: TextStyle(fontWeight: FontWeight.bold),
                      ))
                ],
              ),
            )
          ])
        ],
      ),
    );
  }
}
